<?php

get_header();

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Form verilerini al
    $name = sanitize_text_field($_POST['name']);
    $surname = sanitize_text_field($_POST['surname']);
    $email = sanitize_email($_POST['email']);
    $subject = sanitize_text_field($_POST['subject']);
    $enquiry = sanitize_textarea_field($_POST['enquiry']);

    // E-posta gönder
    $to = get_option('admin_email'); // E-posta adresi olarak admin e-posta adresini alıyoruz
    $headers = array('Content-Type: text/html; charset=UTF-8', 'From: ' . $email);
    $message = "
        <html>
        <head><title>Contact Form Submission</title></head>
        <body>
            <h2>Contact Form Details</h2>
            <p><strong>Name:</strong> $name $surname</p>
            <p><strong>Email:</strong> $email</p>
            <p><strong>Subject:</strong> $subject</p>
            <p><strong>Enquiry:</strong> $enquiry</p>
        </body>
        </html>
    ";

    // wp_mail fonksiyonu ile e-posta gönder
    if (wp_mail($to, $subject, $message, $headers)) {
        echo '<p>Thank you for your message. We will get back to you soon.</p>';
    } else {
        echo '<p>Sorry, something went wrong. Please try again later.</p>';
    }
}
?>

<script>document.querySelector(".header-all").classList.add("header-relative");</script>

<main>
    <section class="contact-title">
        <div class="uk-container">
            <?php
            if ( have_posts() ) :
                while ( have_posts() ) :
                    the_post();
                    the_content();
                endwhile;
            endif;

            wp_reset_query();
            ?>
        </div>
    </section>

    <section class="contact-info-form">
        <div class="uk-container">
            <div class="uk-grid uk-grid-large uk-grid-match" uk-grid>
                <div class="uk-width-1-3@m">
                    <div class="contact-info">
                        <h2>Contact Info</h2>

                        <p class="uk-margin-medium-bottom"><?= get_option('company_address');?></p>

                        <p><span class="uk-text-uppercase">Phone</span> : <a href="tel:<?= get_option('phone_number');?>"><?= get_option('phone_number');?></a></p>
                        <p class="email"><a href="mailto:<?= get_option('email_address');?>"><?= get_option('email_address');?></a></p>
                    </div>
                </div>

                <div class="uk-width-2-3@m">
                    <div class="contact-form">

                        <?= do_shortcode('[contact-form-7 id="8a6dde5" title="İletişim formu 1"]'); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="uk-container p-mobile-zero">
            <div class="uk-grid uk-margin-large-top uk-margin-large-bottom mb-mobile-zero" uk-grid>
                <div class="uk-width-1-1">
                    <div class="contact-map">
                        <iframe
                            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d12004.60024987537!2d29.01624132327725!3d41.21850018172336!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x409fe16ad18db8fb%3A0xd373e48cd06eb312!2zVXNrdW1ydWvDtnksIDM0NDUwIFNhcsSxeWVyL8Swc3RhbmJ1bA!5e0!3m2!1str!2str!4v1735216611174!5m2!1str!2str"
                            style="border: 0;"
                            allowfullscreen=""
                            loading="lazy"
                            referrerpolicy="no-referrer-when-downgrade"
                        ></iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

<?php
get_footer();
?>